directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = true;
    activate_receivers = true;
    output_action = set_local;
  end_startup_options;
end_settings;


driver
end_driver;

data
end_data;

instrument

  gl_scene scene;
    gui
      owner = background;
      position = 15, 35, 800, 600;
      gravity = right, bottom;
      window
        type = normal;
        title = 'Moving Mirror';
      end_window;
    end_gui;
    material
      item
        name = 'sphere_map';
        ambient = 0.100, 0.100, 0.100, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'env.bmp';
      end_item;
    end_material;
    light
      light0
        position = -1, 1, 2, 0;
      end_light0;
    end_light;
    camera
      position = 0, 0, 1.12E+3;
      rotation = 0, 0;
    end_camera;
  end_gl_scene;

  gl_text_display display;
    gui
      owner = scene;
    end_gui;
    location
      translate = -170, 16.4, 283;
      rotate = 0, 0, 0, 1;
      scale = 4.18, 3.93, 4.45;
    end_location;
    range_from = -100;
    low_limit = -20;
    high_limit = 20;
  end_gl_text_display;

  gl_poster mirror;
    activity
      period = 0.05;
    end_activity;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.247, 0.412, 0.559, 1.000;
        diffuse = 1.000, 1.000, 1.000, 0.403;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.761;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'marble03.jpg';
      end_item;
    end_material;
    location
      translate = 0.8833, 11.3, 104;
      rotate = 9.23, -0.998, -0.054, -0.0324;
      scale = 4.12, 4.28, 1;
    end_location;
    reflections = true;

    procedure OnActivate();
    static
      a : real;
      x : real, 0;
      y : real, 1;
      aa : real, 0;
      ax : real, 0;
      ay : real, 1;
      angle : real, 0;
    begin
      ax = ax + 0.025;
      ay = ay + 0.015;
      aa = aa + 0.02;
    
      if ax > ( 2 * Pi ) then
        ax = 0;
      end;
      if ay > ( 2 * Pi ) then
        ay = 0;
      end;
      if aa > ( 2 * Pi ) then
        aa = 0;
      end;
      x = sin( ax );
      y = sin( ay );
      a = sin( aa );
      angle = 80 * a;
    
      display.SetValue( angle );
    
      self.Rotate( angle, 1, 0, x );
      self.RotationCenter( 0, 0, 50 );
    end_procedure;

  end_gl_poster;

end_instrument;

