directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = false;
    activate_receivers = false;
    output_action = set_local;
  end_startup_options;
end_settings;


driver
end_driver;

data

  var
    motion_auto : boolean {init_value = false};
    motion_rotation : boolean {init_value = true};
    motion_none : boolean {init_value = false};
    smoothing_angle : real {init_value = 60};
  end_var;

end_data;

instrument

  panel Browser;
    static
      MX : integer;
      HMove : boolean;
    end_static;

    gui
      owner = background;
      position = 20, 40, 700, 500;
      window
        type = normal;
        title = '3D Model Browser';
      end_window;
    end_gui;

    procedure OnMouseDown( MouseX, MouseY : longint; LeftButton, MiddleButton, RightButton : boolean );
    var
      x, y, w, d : integer;
    begin
      HSplitter.GetRect( x, y, w, d );
      HMove = (MouseX >= x) and (MouseX <= x+w);
      MX = MouseX;
    end_procedure;

    procedure OnMouseUp( MouseX, MouseY : longint; LeftButton, MiddleButton, RightButton : boolean );
    var
      dx : integer;
      xs, ys, ws, ds : integer;
      x, y, w, d : integer;
    begin
      if HMove then
        dx = MouseX - MX;
        HSplitter.GetRect( xs, ys, ws, ds );
        HSplitter.MoveTo( xs + dx, 0 );
        LeftPanel.GetRect( x, y, w, d );
        LeftPanel.Size( w + dx, d );
        RightPanel.GetRect( x, y, w, d );
        RightPanel.NewRect( x + dx, y, w - dx, d );
      end;
      HMove = false;
    end_procedure;

    procedure OnMouseMove( MouseX, MouseY : longint; LeftButton, MiddleButton, RightButton : boolean );
    var
      dx : integer;
      xs, ys, ws, ds : integer;
      x, y, w, d : integer;
    begin
      if HMove then
        dx = MouseX - MX;
        HSplitter.GetRect( xs, ys, ws, ds );
        HSplitter.MoveTo( xs + dx, 0 );
        LeftPanel.GetRect( x, y, w, d );
        LeftPanel.Size( w + dx, d );
        RightPanel.GetRect( x, y, w, d );
        RightPanel.NewRect( x + dx, y, w - dx, d );
        MX = MouseX;
      end;
    end_procedure;

    procedure ScanRoot( Drive : string );
    begin
      FileTree.ScanDir( 0, Drive );
    end_procedure;

    procedure GetSelectedPath(): string;
    var
      Path : string;
    begin
      FileList.GetSelected( Path );
      return FileTree.GetPath() + '\' + Path;
    end_procedure;

  end_panel;

  box HSplitter;
    gui
      owner = Browser;
      position = 300, 0, 8, 500;
      gravity = bottom;
    end_gui;
    colors
      interior = lgray;
      border = dgray;
    end_colors;
  end_box;

  panel LeftPanel;
    gui
      owner = Browser;
      position = 0, 0, 300, 500;
      gravity = bottom;
    end_gui;
  end_panel;

  switch switch_1;
    gui
      owner = LeftPanel;
      position = 265, 7, 14, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = '  ';
    false_text = '  ';
    colors
      true_paper = white;
      false_paper = white;
    end_colors;

    procedure OnOutput( Output : boolean );
    begin
      Scene.SetColor( 'background', 255, 255, 255 );
    end_procedure;

  end_switch;

  switch switch_1;
    gui
      owner = LeftPanel;
      position = 249, 7, 14, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = '  ';
    false_text = '  ';
    colors
      true_paper = dgray;
      false_paper = dgray;
    end_colors;

    procedure OnOutput( Output : boolean );
    begin
      Scene.SetColor( 'background', 127, 127, 127 );
    end_procedure;

  end_switch;

  switch switch_1;
    gui
      owner = LeftPanel;
      position = 233, 7, 14, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = '  ';
    false_text = '  ';
    colors
      true_paper = black;
      false_paper = black;
    end_colors;

    procedure OnOutput( Output : boolean );
    begin
      Scene.SetColor( 'background', 0, 0, 0 );
    end_procedure;

  end_switch;

  label label_4;
    gui
      owner = LeftPanel;
      position = 208, 90;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'smoothing angle';
    end_text_list;
  end_label;

  control control_3;
    gui
      owner = LeftPanel;
      position = 138, 88, 60, 18;
    end_gui;
    output = smoothing_angle;
    mode = edit_box;
    range_to = 180;
    init_value = 60;
    dec_places = 0;

    procedure OnOutput( Output : real );
    begin
      Model.SetSmoothingAngle( Output );
    end_procedure;

  end_control;

  multi_switch multi_switch_2;
    gui
      owner = LeftPanel;
      position = 8, 72, 118, 34;
    end_gui;
    mode = radio_button;
    item
      text = 'original normals';
    end_item;
    item
      text = 'calculated normals';
    end_item;

    procedure OnIndex( Index : longint );
    begin
      Model.SetSmoothingAngle( smoothing_angle );
      Model.SetNormalsMode( Index );
    end_procedure;

  end_multi_switch;

  multi_switch multi_switch_1;
    gui
      owner = LeftPanel;
      position = 70, 6, 81, 66;
    end_gui;
    mode = radio_button;
    item
      text = 'smooth';
    end_item;
    item
      text = 'flat';
    end_item;
    item
      text = 'wireframe';
    end_item;
    item
      text = 'points';
    end_item;

    procedure OnIndexOutput( Index : longint; Output : boolean );
    begin
      if Output then
        switch Index of
        case 1;
          Model.SetRenderBitsHierarchy( true, false, false, false );
        case 2;
          Model.SetRenderBitsHierarchy( false, true, false, false );
        case 3;
          Model.SetRenderBitsHierarchy( false, false, true, false );
        case 4;
          Model.SetRenderBitsHierarchy( false, false, false, true );
        end;
      end;
    end_procedure;

  end_multi_switch;

  multi_switch multi_switch_1;
    gui
      owner = LeftPanel;
      position = 8, 5, 81, 50;
    end_gui;
    mode = radio_button;
    item
      output = motion_none;
      text = 'static';
    end_item;
    item
      output = motion_rotation;
      text = 'rotation';
      selected = true;
    end_item;
    item
      output = motion_auto;
      text = 'swing';
    end_item;
  end_multi_switch;

  tree FileTree;
    static
      HRoot : longcard {init_value = MaxLongCard};
    end_static;

    gui
      owner = LeftPanel;
      position = 0, 134, 300, 366;
      gravity = right, bottom;
    end_gui;

    procedure DeleteSubTree( Owner : longcard );
    var
      n : longcard;
    begin
      n = GetItems( Owner ); 
      while n > 0 do
        Delete( Owner, n );
        n = n - 1;
      end;
    end_procedure;

    procedure ScanDir( Owner : longcard; Path : string );
    var
      h         : longcard;
      Handle    : longcard;
      DirEntry  : string;
      Directory : boolean;
      ErrorCode : longcard;
      ErrorText : string;
      Head      : string;
      Tail      : string;
      FTree     : boolean;
      ok        : boolean;
      extension : string;
    begin
      FTree = Owner <> HRoot;
      if Owner = 0 then
        DeleteTree();
        HRoot = Append( 0, Path, 'Disk.ico' );
        Owner = HRoot;
      end; (* if *)
      if IsExpanded( Owner ) then
         DeleteSubTree( Owner );
      end; (* if *)
      FileList.DeleteList();
      ok = files.GetFirstEntry( '*.*', Path, Handle, DirEntry, Directory, ErrorCode, ErrorText );
      while ok do
        files.SplitPath( DirEntry, Head, Tail );
        if (Tail <> '.') and (Tail <> '..') then
          if Directory then
            if FTree then
              h = Append( Owner, Tail, 'FolderO.ico', 'FolderC.ico' );
            end; (* if *)
          else
            extension = caps( files.GetExtension( DirEntry ) );
            if ( extension = 'OBJ' ) or
               ( extension = '3DS' ) or
               ( extension = 'DXF' ) then
              FileList.Append( Tail, 'File.ico' );
            end;  
          end; (* if *)
        end; (* if *)
        ok = files.GetNextEntry( Handle, DirEntry, Directory, ErrorCode, ErrorText );
      end; (* while *)
      FileList.UpdateList();
      UpdateTree();
      Expand( Owner );
    end_procedure;

    procedure GetPath(): string;
    var
      h : longcard;
      o : longcard;
      p : string;
      s : string;
    begin
      GetSelected( p );
      h = GetSelectedHandle();
      o = GetOwner( h );
      while o <> 0 do
        GetText( o, s );
        p = s + iif( p <> '', '\', '' ) + p;
        o = GetOwner( o );
      end; (* while *)
      return p;
    end_procedure;

    procedure OnOutput( Owner, Index : longcard );
    begin
      ScanDir( GetSelectedHandle(), GetPath() );
    end_procedure;

  end_tree;

  string_switch Drives;
    gui
      owner = LeftPanel;
      position = 0, 108, 300, 25;
      gravity = right;
    end_gui;
    startup_options
      call_procedures = true;
    end_startup_options;
    item
      text = 'C:';
      selected = true;
    end_item;
    item
      text = 'D:';
    end_item;
    item
      text = '\\miranda\data';
    end_item;

    procedure OnStartup();
    begin
      SetIndex( 1 );
    end_procedure;

    procedure OnOutput( Output : string );
    begin
      Browser.ScanRoot( Output );
    end_procedure;

  end_string_switch;

  panel RightPanel;
    static
      MY : integer;
      VMove : boolean;
    end_static;

    gui
      owner = Browser;
      position = 308, 0, 392, 500;
      gravity = right, bottom;
    end_gui;

    procedure OnMouseDown( MouseX, MouseY : longint; LeftButton, MiddleButton, RightButton : boolean );
    var
      x, y, w, d : integer;
    begin
      VSplitter.GetRect( x, y, w, d );
      VMove = (MouseY >= y) and (MouseY <= y + d);
      MY = MouseY;
    end_procedure;

    procedure OnMouseUp( MouseX, MouseY : longint; LeftButton, MiddleButton, RightButton : boolean );
    var
      dy : integer;
      xs, ys, ws, ds : integer;
      x, y, w, d : integer;
    begin
      if VMove then
        dy = MouseY - MY;
        VSplitter.GetRect( xs, ys, ws, ds );
        VSplitter.MoveTo( 0, ys + dy );
        Scene.GetRect( x, y, w, d );
        Scene.Size( w, d + dy );
        FileList.GetRect( x, y, w, d );
        FileList.NewRect( x, y + dy, w, d - dy );
      end;
      VMove = false;
    end_procedure;

    procedure OnMouseMove( MouseX, MouseY : longint; LeftButton, MiddleButton, RightButton : boolean );
    var
      dy : integer;
      xs, ys, ws, ds : integer;
      x, y, w, d : integer;
    begin
      if VMove then
        dy = MouseY - MY;
        VSplitter.GetRect( xs, ys, ws, ds );
        VSplitter.MoveTo( 0, ys + dy );
        Scene.GetRect( x, y, w, d );
        Scene.Size( w, d + dy );
        FileList.GetRect( x, y, w, d );
        FileList.NewRect( x, y + dy, w, d - dy );
    
        MY = MouseY;
      end;
    end_procedure;

  end_panel;

  gl_scene Scene;
    gui
      owner = RightPanel;
      position = 0, 0, 391, 374;
      gravity = right, bottom;
    end_gui;
    zooming_method = fixed_content;
    camera
      position = 0, 0, 689;
      rotation = 0, 0;
    end_camera;
  end_gl_scene;

  gl_model Model;
    activity
      period = 0.1;
    end_activity;
    gui
      owner = Scene;
    end_gui;
    location
      translate = -1.77, 0.2136, 337;
      rotate = 0, 0, 0, 1;
      scale = 0.99, 0.975, 0.99;
    end_location;

    procedure OnActivate();
    static
      a : real;
      x : real, 0;
      y : real, 1;
      aa : real, 0;
      ax : real, 0;
      ay : real, 1;
      angle : real, 0;
      rotangle : real, 0;
    begin
      if motion_auto then
        ax = ax + 0.025;
        ay = ay + 0.015;
        aa = aa + 0.02;
      
        if ax > ( 2 * Pi ) then
          ax = 0;
        end;
        if ay > ( 2 * Pi ) then
          ay = 0;
        end;
        if aa > ( 2 * Pi ) then
          aa = 0;
        end;
        x = sin( ax );
        y = sin( ay );
        a = sin( aa );
        angle = 90 * a;
      
        self.Rotate( angle, 0, 1, x );
      elsif motion_rotation then
        rotangle = rotangle + 1.5;
        if rotangle > 360 then
          rotangle = rotangle - 360;
        end;
        self.Rotate( rotangle, 0, 1, 0 );
      end;
    end_procedure;

  end_gl_model;

  box VSplitter;
    gui
      owner = RightPanel;
      position = 0, 374, 391, 8;
    end_gui;
    colors
      interior = lgray;
      border = dgray;
    end_colors;
  end_box;

  listbox FileList;
    gui
      owner = RightPanel;
      position = 0, 382, 392, 117;
      gravity = right, top;
    end_gui;

    procedure OnOutput( Index : longcard );
    begin
      Model.LoadModel( Browser.GetSelectedPath() );
    end_procedure;

  end_listbox;

end_instrument;

