directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = false;
    activate_receivers = false;
    output_action = set_local;
  end_startup_options;
end_settings;


driver
end_driver;

data
end_data;

instrument

  gl_scene scene;
    activity
      period = 0.02;
    end_activity;
    gui
      owner = background;
      position = 15, 35, 800, 600;
      window
        type = normal;
        title = 'User Matrix';
      end_window;
    end_gui;
    camera
      position = 0, 0, 1.12E+3;
      rotation = 0, 0;
    end_camera;

    procedure OnActivate();
    static
      angle : real, 0;
      matrix : array [0..15] of real, 0;
      c : real, 0;
      s : real, 0;
      cc : real, 0;
      x : real, 0;
      y : real, 1;
      z : real, 0;
    begin
      angle = angle + 0.7;
      if angle > 360 then
        angle = angle -360;
      end;
    
      (* build in rotate *)
      pt1.Rotate( angle, x, y, z );
    
      (* user matrix rotate *);
      c := cos( Pi * ( angle / 180.0 ) );
      s := sin( Pi * ( angle / 180.0 ) );
      cc := 1.0 - c;
    
      matrix[ 3 ] := 0;
      matrix[ 7 ] := 0;
      matrix[ 11 ] := 0;
      matrix[ 12 ] := 0;
      matrix[ 13 ] := 0;
      matrix[ 14 ] := 0;
      matrix[ 15 ] := 1;
    
      matrix[ 0 ]  := ( x * x * cc ) + c;
      matrix[ 1 ]  := ( y * x * cc ) + ( z * s );
      matrix[ 2 ]  := ( x * z * cc ) - ( y * s );
      matrix[ 4 ]  := ( x * y * cc ) - ( z * s );
      matrix[ 5 ]  := ( y * y * cc ) + c;
      matrix[ 6 ]  := ( y * z * cc ) + ( x * s );
      matrix[ 8 ]  := ( x * z * cc ) + ( y * s );
      matrix[ 9 ]  := ( y * z * cc ) - ( x * s );
      matrix[ 10 ] := ( z * z * cc ) + c;
      pt2.SetMatrix( matrix );
    end_procedure;

  end_gl_scene;

  gl_pointer pt2;
    gui
      owner = scene;
    end_gui;
    location
      translate = 196, 44.7, 334;
      rotate = 0, 0, 0, 1;
      scale = 2.86, 2.86, 2.86;
    end_location;
  end_gl_pointer;

  gl_pointer pt1;
    gui
      owner = scene;
    end_gui;
    location
      translate = -200, 42.9, 334;
      rotate = 0, 0, 0, 1;
      scale = 2.86, 2.86, 2.86;
    end_location;
  end_gl_pointer;

end_instrument;

